/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
using System;
namespace org.owasp.appsensor
{

    /**
     * This interface specifies the requirements for a user object that is 
     * utilized by AppSensor.  This object is used throughout the application 
     * both in an attempt to identify the user performing the action for 
     * purposes of logging as well as taking action on the user such as 
     * logout and disable.
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since May 6, 2010
     *
     */
    public interface ASUser
    {
        /**
         * Gets this user's account id number.
         * 
         * @return the account id
         */
        long AccountId { get; }

        /**
         * Gets this user's account name.
         * 
         * @return the account name
         */
        String AccountName { get; }

        /**
         * Checks if user is anonymous.
         * 
         * @return true, if user is anonymous
         */
        bool Anonymous { get; }

        /**
         * Logout this user.
         */
        void Logout();

        /**
         * Disable this user's account.
         */
        void Disable();

        /**
         * Checks if this user's account is currently enabled.
         * 
         * @return true, if account is enabled 
         */
        bool Enabled { get; }

    }
}